#include <ntifs.h>
#include <ntddk.h>

#define DEVICE_NAME_STRING   L"KBCDrv"

typedef struct _IO_PORT_
{
   INT bPress;
   unsigned int vKey;
}_IO_PORT_DATA_;

PUCHAR KBC_KEY_DATA = (PUCHAR)0x60;
PUCHAR KBC_KEY_CMD = (PUCHAR)0x64;

#define IBUFFER_FULL      0x02
#define OBUFFER_FULL      0x01

void KBCWait4IBE(void)
{
  int dwVal = 0;
  do {dwVal = READ_PORT_UCHAR(KBC_KEY_CMD);} while((dwVal & 0x2) > 0);
}

void KBCWait4DBE(void)
{
   int dwVal = 0;
   do {dwVal = READ_PORT_UCHAR(KBC_KEY_CMD);} while((dwVal & 0x1) > 0);
}

void LightOn(unsigned char value)
{
   KBCWait4DBE();
   KBCWait4IBE();
   WRITE_PORT_UCHAR(KBC_KEY_CMD, 0x97);

   KBCWait4IBE();
   WRITE_PORT_UCHAR(KBC_KEY_DATA, value);
}

VOID OnUnload(IN PDRIVER_OBJECT DriverObject)
{
   UNICODE_STRING ustr;
   RtlInitUnicodeString(&ustr, L"\\??\\" DEVICE_NAME_STRING);
   IoDeleteSymbolicLink (&ustr);
   IoDeleteDevice(DriverObject->DeviceObject);
}

NTSTATUS Create(PDEVICE_OBJECT pDevice,PIRP Irp)
{
   NTSTATUS ntStatus = STATUS_SUCCESS;
   return ntStatus;
}

NTSTATUS Close(PDEVICE_OBJECT pDevice,PIRP Irp)
{
   NTSTATUS ntStatus = STATUS_SUCCESS;
   return ntStatus;
}

NTSTATUS Control(PDEVICE_OBJECT pDevice, PIRP Irp)
{
	NTSTATUS ntStatus = STATUS_SUCCESS;
	ULONG value;
	unsigned char output;
	
	PVOID buf = Irp->AssociatedIrp.SystemBuffer;
	PIO_STACK_LOCATION sl = IoGetCurrentIrpStackLocation(Irp);
	value = sl->Parameters.DeviceIoControl.IoControlCode;
	output = (unsigned char)value;
	
	LightOn(output);
	IoCompleteRequest(Irp, IO_NO_INCREMENT);

	return ntStatus;
}

NTSTATUS DriverEntry(IN PDRIVER_OBJECT DriverObject,IN PUNICODE_STRING RegistryPath)
{
   PDEVICE_OBJECT deviceObject;
   NTSTATUS status;
   UNICODE_STRING uniNameString, uniDOSString;

   RtlInitUnicodeString(&uniNameString, L"\\Device\\" DEVICE_NAME_STRING);
   RtlInitUnicodeString(&uniDOSString, L"\\??\\" DEVICE_NAME_STRING);

   status = IoCreateDevice(DriverObject,0,&uniNameString,FILE_DEVICE_UNKNOWN,FILE_DEVICE_SECURE_OPEN,FALSE,&deviceObject);
   if(!NT_SUCCESS(status)) return status;

   LightOn(0x04);

   DriverObject->MajorFunction[IRP_MJ_CREATE] = Create;
   DriverObject->MajorFunction[IRP_MJ_CLOSE] = Close;
   DriverObject->MajorFunction[IRP_MJ_DEVICE_CONTROL] = Control;
   deviceObject->Flags |= DO_DIRECT_IO;
   deviceObject->Flags &= (~DO_DEVICE_INITIALIZING);

   status = IoCreateSymbolicLink (&uniDOSString, &uniNameString);
   if(!NT_SUCCESS(status)) return status;

   DriverObject->DriverUnload = OnUnload;

   return status;
} 
